[setup]
AppName=My Application
AppVersion=1.5
DefaultDirName={pf}
ShowLanguageDialog=auto

[Languages]
Name: rus; MessagesFile: compiler:Languages\Russian.isl
Name: eng; MessagesFile: compiler:Default.isl

[CustomMessages]
; 
rusButtonBack=< &
rusButtonNext=& >
rusButtonCancel=
rusSetupWindowTitle=  %1
rusWelcomeLabel1=    %1
rusWelcomeLabel2=  %1,  %2   .%n%n      ,  .%n%n ,  ,  ,     .

; English
engButtonBack=< &Back
engButtonNext=&Next >
engButtonCancel=Cancel
engSetupWindowTitle=Setup  %1
engWelcomeLabel1=Welcome to the %1 Setup Wizard
engWelcomeLabel2=This will install %1 version %2 on your computer.%n%nIt is recommended that you close all other applications before continuing.%n%nClick Next to continue, or Cancel to exit Setup.

[Code]
var
  lang: String;
  langBtn: TButton;

procedure ChangeLang();
begin
  WizardForm.BackButton.Caption:= CustomMessage(lang+'ButtonBack');
  WizardForm.NextButton.Caption:= CustomMessage(lang+'ButtonNext');
  WizardForm.CancelButton.Caption:= CustomMessage(lang+'ButtonCancel');
  WizardForm.Caption:= FmtMessage(CustomMessage(lang+'SetupWindowTitle'), ['{#SetupSetting('AppName')}']);
  WizardForm.WelcomeLabel1.Caption:= FmtMessage(CustomMessage(lang+'WelcomeLabel1'), ['{#SetupSetting('AppName')}']);
  WizardForm.WelcomeLabel2.Caption:= FmtMessage(CustomMessage(lang+'WelcomeLabel2'), ['{#SetupSetting('AppName')}', '{#SetupSetting('AppVersion')}']);
end;

procedure LangBtnClick(Sender: TObject);
begin
  if lang='rus' then begin
    lang:= 'eng';
    langBtn.Caption:= '';
  end else begin
    lang:= 'rus';
    langBtn.Caption:= 'eng';
  end;
  ChangeLang();
end;

procedure InitializeWizard;
begin
  langBtn:= TButton.Create(WizardForm);
  with langBtn do begin
    SetBounds(10,WizardForm.CancelButton.Top,30,WizardForm.CancelButton.Height)
    OnClick:= @LangBtnClick;
    Parent:= WizardForm;
  end;

  if ActiveLanguage='rus' then begin
    lang:= 'rus';
    langBtn.Caption:= 'eng';
  end else begin
    lang:= 'eng';
    langBtn.Caption:= '';
  end;
end;
